unit Dpunit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, DROPPANL, Menus;

type
  TDPForm = class(TForm)
    ReplacePanel: TDropPanel;
    LocLabel: TLabel;
    AddPanel: TDropPanel;
    ClearBtn: TButton;
    FileList: TListBox;
    Label1: TLabel;
    LocBevel: TBevel;
    HelpBtn: TButton;
    procedure ReplacePanelFileDrop(Sender: TObject; Files: TStringList; X,
      Y: Integer);
    procedure AddPanelFileDrop(Sender: TObject; Files: TStringList; X,
      Y: Integer);
    procedure ClearBtnClick(Sender: TObject);
    procedure HelpBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DPForm: TDPForm;

implementation

{$R *.DFM}


procedure TDPForm.ReplacePanelFileDrop(Sender: TObject;
  Files: TStringList; X, Y: Integer);
begin
  FileList.Items.Clear;
  FileList.Items.AddStrings( Files );
  LocLabel.Caption := '(' + IntToStr(X) + ', ' + IntToStr(Y) + ')';
end;

procedure TDPForm.AddPanelFileDrop(Sender: TObject; Files: TStringList; X,
  Y: Integer);
begin
  FileList.Items.AddStrings( Files );
  LocLabel.Caption := '(' + IntToStr(X) + ', ' + IntToStr(Y) + ')';
end;

procedure TDPForm.ClearBtnClick(Sender: TObject);
begin
  FileList.Items.Clear;
  LocLabel.Caption := '';
end;

procedure TDPForm.HelpBtnClick(Sender: TObject);
begin
  MessageDlg( 'This program is a trivial demonstration of the TDropPanel ' +
              'component which allows you to have any number of panels on ' +
              'your form that independently accept drag and drop files.' +
              #13 + #13 +
              'Drag and drop files directly on list at the left ' +
              'to add them to the list.' + #13 + #13 +
              'Drag and drop files onto button panel to replace the items ' +
              'in the list at the left.', mtInformation, [mbOK], 0 );
end;

end.
